/**
  ******************************************************************************
  * @file    main.c 
  * @author  Ruediger R. Asche
  * @version V1.0.0
  * @date    July 14, 2016
  * @brief   Program entry point
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, THE AUTHOR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  ******************************************************************************  
  */ 

/* Includes ------------------------------------------------------------------*/
#include "stm32f4_discovery.h"
#include "freertos.h"
#include "task.h"

#include "fw.h"

#define LED_ORANGE LED3
#define LED_GREEN  LED4
#define LED_BLUE   LED6
#define LED_RED    LED5

#define BLINKEDELAYINMS 1000
#define BLINKTASKPRIORITY (configMAX_PRIORITIES-2)

SECTION_FLASH_MCB_FW const MCB g_fw_mcb = 
{
    MCB_SIGNATURE_FW,
    {
        ((unsigned long)&_eidata - 0x8000000),
        (unsigned long)&g_pfnVectorsFW,
        {FW_VERSION_MAJOR,FW_VERSION_MINOR,FW_VERSION_BETA,FW_VERSION_RESERVED},
    },
    {
        MIT_VECTOR_COUNT,
        {
            0,0,0,0
        }
    }
};

SECTION_FLASH_MCB_BL const MCB g_bl_mcb = {0}; // NOLOAD 

/** @brief Example for cross-module calling from Application to IVT. Passes Interrupts on.
 *
 *
 *  @return none. Function does not return.
 */

void DispatchISRToBL(void)
{
    (g_bl_mcb.m_Mit.m_Vectors[MIT_BL_VECTOR_DISPATCHISRTOBL])();
}

/** @brief Example for cross-module calling from Application to IVT. Toggles an On Board LED.
 *
 *
 *  @param p_LED Indicator of LED to drive.
 *  @return none. Function does not return.
 */

void ToggleLEDViaBL(unsigned long p_LED)
{
    ((MITVector1ul)(g_bl_mcb.m_Mit.m_Vectors[MIT_BL_TOGGLELED]))(p_LED);

  
}

/* Private functions ---------------------------------------------------------*/

/** @brief FreeRTOS task function
 *
 *
 *  @param p_Dum FreeRTOS Task Parameter. Unused.
 *  @return none. Function does not return.
 */

void BlinkTest(void *p_Dum)
{
  while (1)
  {
    ToggleLEDViaBL(LED_ORANGE);
    ToggleLEDViaBL(LED_BLUE);

    vTaskDelay(BLINKEDELAYINMS);

    ToggleLEDViaBL(LED_GREEN);
    ToggleLEDViaBL(LED_RED);

    vTaskDelay(BLINKEDELAYINMS);
  }  
}

/** @brief Application entry point
 *
 *
 *  @return Dummy (required by unused C Runtime Code). Function does not return unless vTaskStartScheduler() has a problem.
 */

int main(void)
{  
  /* Initialization of LEDs has already been performed by the boot loader */

	xTaskCreate(BlinkTest, "BlinkTask", configMINIMAL_STACK_SIZE,
			0, BLINKTASKPRIORITY, (TaskHandle_t *) 0);

  /* Start the scheduler */
	vTaskStartScheduler();
}
